DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @DtIniFilial DATETIME
DECLARE @DtIniMesFecha DATETIME
DECLARE @QtdeMesesProc INT 
DECLARE @QtdeMesProc INT
SET NOCOUNT ON
	DECLARE filiaisFecha CURSOR FAST_FORWARD FOR
		SELECT
			CD_EMP,
			CD_FILIAL
			,DT_INI_SISTEMA
		FROM
			PRC_FILIAL

		OPEN filiaisFecha

		FETCH NEXT FROM filiaisFecha INTO @CD_EMP, @CD_FILIAL, @DtIniFilial

		WHILE @@FETCH_STATUS = 0
			BEGIN
					PRINT 'Analisando filial '
								+ CONVERT(VARCHAR(10), @CD_FILIAL)

				SET @QtdeMesesProc=DATEDIFF(MONTH,@DtIniFilial,GETDATE())-1;
				SET @QtdeMesProc=0
				WHILE @QtdeMesProc <= @QtdeMesesProc
				BEGIN
					set @DtIniMesFecha=dateadd(month,@QtdeMesProc,@DtIniFilial) 
					DELETE FROM 
						PRC_FILIAL_EST_FECHA
					WHERE
						CD_EMP=@CD_EMP
						AND CD_FILIAL=@CD_FILIAL
						AND ANO_FECHA = YEAR(@DtIniMesFecha)
						AND MES_FECHA = MONTH(@DtIniMesFecha)
	
					INSERT INTO 
						PRC_FILIAL_EST_FECHA
					(CD_EMP,
					CD_FILIAL,
					ANO_FECHA,
					MES_FECHA,
					CD_USU,
					DT_CAD,
					ANO_MES_FECHA)
					SELECT
						@CD_EMP,
						@CD_FILIAL,
						YEAR(@DtIniMesFecha),
						MONTH(@DtIniMesFecha),
						1,
						GETDATE(),
						YEAR(@DtIniMesFecha)*100+MONTH(@DtIniMesFecha)

					SELECT @QtdeMesProc = @QtdeMesProc + 1
				END
				FETCH NEXT FROM filiaisFecha INTO @CD_EMP, @CD_FILIAL, @DtIniFilial
			END

		PRINT 'Concludo.'

		CLOSE filiaisFecha;

		DEALLOCATE filiaisFecha;





